

IF EXISTS (SELECT 1 FROM SYS.PROCEDURES WHERE NAME ='P_DELETA_PRODUTO_DUPLICADO ')
    BEGIN
    DROP PROCEDURE P_DELETA_PRODUTO_DUPLICADO
    END 
GO
/*
=======================================================================================
'Job.................:  
'Funo..............: 
'Objetivo............: Alterar codigo do produto 
'Tabelas.............: 
'Dt Modificao......: 24/12/2020
'Modificao.........: Tag #A001 S realizar alterao se o produto destino  e a filial existir na EST_PROD_CPL
'=======================================================================================
Tag #A001 - Alterao do codigo  
Tag #I001 - Incluso de novo codigo 
*/
CREATE PROCEDURE P_DELETA_PRODUTO_DUPLICADO (@CD_PROD_ORIG INT , @CD_PROD_DEST INT, @CD_EMP INT=1 )
AS 
BEGIN
SET NOCOUNT ON ;
DECLARE @ErrorMessage Varchar(2000);
DECLARE @ErrorTable Varchar(2000);
DECLARE @ErrorSeverity INT=16;
DECLARE @ErrorState INT=1;       
-- exec P_DELETA_PRODUTO_DUPLICADO 53525,25493 


IF EXISTS (SELECT * 
FROM EST_NF_ENT_IT A 
	 JOIN EST_NF_ENT_IT B ON A.CD_EMP = B.CD_EMP
							AND A.CD_NF	= B.CD_NF
							AND A.CD_FILIAL = B.CD_FILIAL
WHERE A.CD_EMP = @CD_EMP
	  AND A.CD_PROD =@CD_PROD_ORIG
      AND B.CD_PROD =@CD_PROD_DEST) 
BEGIN
	RAISERROR ('Ambos produtos estao na mesma nota de entrada.', 16, 1);
	RETURN;
END;

  BEGIN TRY 
    print 'TLV_PROD_FAMILIA_EST_PROD '
    SET @ErrorTable = 'TLV_PROD_FAMILIA_EST_PROD '
    DELETE FROM  TLV_PROD_FAMILIA_EST_PROD WHERE CD_PROD =@CD_PROD_ORIG 

    print 'TLV_PED_VD_IT '
    SET @ErrorTable = 'TLV_PED_VD_IT'
    DELETE FROM  TLV_PED_VD_IT WHERE CD_PROD =@CD_PROD_ORIG 

    print 'TLV_MSG_EST_PROD '
    SET @ErrorTable = 'TLV_MSG_EST_PROD'
    DELETE FROM  TLV_MSG_EST_PROD WHERE CD_PROD =@CD_PROD_ORIG 

    print 'TLV_CLIENTES_PRO_CONTINUO1 '
    SET @ErrorTable = 'TLV_CLIENTES_PRO_CONTINUO1'
    DELETE FROM  TLV_CLIENTES_PRO_CONTINUO1 WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'TLV_CLIENTES_PRO_CONTINUO '
    SET @ErrorTable = 'TLV_CLIENTES_PRO_CONTINUO'
    DELETE FROM  TLV_CLIENTES_PRO_CONTINUO WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'TLV_CAMPANHA_IT1 '
    SET @ErrorTable = 'TLV_CAMPANHA_IT1'
    DELETE FROM  TLV_CAMPANHA_IT1 WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'TLV_CAMPANHA_IT '
    SET @ErrorTable = 'TLV_CAMPANHA_IT'
    DELETE FROM  TLV_CAMPANHA_IT WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'SNGPC_MOVIMENTACAO_AUDIT '
    SET @ErrorTable = 'SNGPC_MOVIMENTACAO_AUDIT'
    DELETE FROM  SNGPC_MOVIMENTACAO_AUDIT WHERE CD_PROD =@CD_PROD_ORIG
     
    print 'SNGPC_MOVIMENTACAO '
    SET @ErrorTable = 'SNGPC_MOVIMENTACAO'
    DELETE FROM  SNGPC_MOVIMENTACAO WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'SNGPC_HIST_MOV_LOTE '
    SET @ErrorTable = 'SNGPC_HIST_MOV_LOTE'
    DELETE FROM  SNGPC_HIST_MOV_LOTE WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'SNGPC_EST_PROD_LOTE '
    SET @ErrorTable = 'SNGPC_EST_PROD_LOTE'
    DELETE FROM  SNGPC_EST_PROD_LOTE WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'SNGPC_EST_PROD_CPL '
    SET @ErrorTable = 'SNGPC_EST_PROD_CPL'
    DELETE FROM  SNGPC_EST_PROD_CPL WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'SNGPC_EST_PROD '
    SET @ErrorTable = 'SNGPC_EST_PROD'
    DELETE FROM  SNGPC_EST_PROD WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'RC_MOV_PBM '
    SET @ErrorTable = 'RC_MOV_PBM'
    DELETE FROM  RC_MOV_PBM WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'RC_CLI_EST_PROD '
    SET @ErrorTable = 'RC_CLI_EST_PROD'
    DELETE FROM  RC_CLI_EST_PROD WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'RC_CLI_CONV_EST_PROD_CPL_DESCONTO_PDV '
    SET @ErrorTable = 'RC_CLI_CONV_EST_PROD_CPL_DESCONTO_PDV'
    DELETE FROM  RC_CLI_CONV_EST_PROD_CPL_DESCONTO_PDV WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'RC_CLI_CONV_EST_PROD_CPL_DESCONTO '
    SET @ErrorTable = 'RC_CLI_CONV_EST_PROD_CPL_DESCONTO'
    DELETE FROM  RC_CLI_CONV_EST_PROD_CPL_DESCONTO WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_GRP_COMIS_PDV_CPL '
    SET @ErrorTable = 'EST_GRP_COMIS_PDV_CPL'
    DELETE FROM  EST_GRP_COMIS_PDV_CPL WHERE CD_PROD =@CD_PROD_ORIG 

--------------------------------------------------------------------------------------------------------------------------------------------
--ALTERANDO PRODUTO NO PDV
--------------------------------------------------------------------------------------------------------------------------------------------
     
    print 'PDV_VD_IT '
    SET @ErrorTable = 'PDV_VD_IT'
    UPDATE  PDV_VD_IT SET CD_PROD =@CD_PROD_DEST	    WHERE CD_EMP = @CD_EMP AND CD_PROD =@CD_PROD_ORIG 
    
    print 'PDV_CUPOM_IT '
    SET @ErrorTable = 'PDV_CUPOM_IT'
    UPDATE  PDV_CUPOM_IT SET CD_PROD =@CD_PROD_DEST   WHERE CD_EMP = @CD_EMP AND CD_PROD =@CD_PROD_ORIG
     
    print 'IMP_PROD_PLU '    
    SET @ErrorTable = 'IMP_PROD_PLU'
    UPDATE  IMP_PROD_PLU SET CD_PROD =@CD_PROD_DEST   WHERE CD_EMP = @CD_EMP AND CD_PROD =@CD_PROD_ORIG 

	print 'EST_NF_SAI_IT'    
    SET @ErrorTable = 'EST_NF_SAI_IT'
    UPDATE  EST_NF_SAI_IT SET CD_PROD =@CD_PROD_DEST   WHERE CD_EMP = 1 AND CD_PROD =@CD_PROD_ORIG 
     

	   declare @cd_nf int,@cd_filial int 
	   declare NOTAS cursor for
	   SELECT 
			 a.cd_filial
			,a.cd_nf 
	   FROM 
		  EST_NF_ENT_IT A 
		  JOIN EST_NF_ENT_IT B ON 
		  A.CD_EMP	 = B.CD_EMP AND
		  A.CD_NF	 = B.CD_NF AND
		  A.CD_FILIAL = B.CD_FILIAL
	   WHERE
			   A.CD_EMP = @CD_EMP
		   AND A.CD_PROD =@CD_PROD_ORIG
		  AND B.CD_PROD =@CD_PROD_DEST
	   OPEN NOTAS

		--Atribuindo valores do select nas variveis
		FETCH NEXT FROM notas INTO @CD_FILIAL,@cd_nf


		--Iniciando lao
		WHILE @@FETCH_STATUS = 0
		 BEGIN 

		    UPDATE EST_NF_ENT_IT
		SET
		    QT_IT =
	   (
		  SELECT SUM(QT_IT)
		  FROM EST_NF_ENT_IT
		  WHERE cd_emp = @CD_EMP
			   and cd_nf = @cd_nf
			   AND cd_filial = @CD_FILIAL
			   AND cd_prod IN(@CD_PROD_ORIG, @CD_PROD_DEST)
	   )
		  WHERE cd_emp = @CD_EMP
			   and cd_nf = @cd_nf
			   AND cd_filial = @CD_FILIAL
			   AND cd_prod IN(@CD_PROD_ORIG, @CD_PROD_DEST);

		  DELETE FROM EST_NF_ENT_IT
		  WHERE cd_emp = @CD_EMP
			   AND cd_nf = @cd_nf
			   AND cd_filial = @CD_FILIAL
			   AND cd_prod = @CD_PROD_ORIG;
		 FETCH NEXT FROM NOTAS INTO @CD_FILIAL,@CD_NF
		 end 
	   CLOSE NOTAS
	   DEALLOCATE NOTAS

	print 'EST_FECHA '
    SET @ErrorTable = 'EST_FECHA' 
    DELETE FROM  EST_NF_ENT_IT_HIST_CUSTO WHERE CD_EMP = @CD_EMP and CD_PROD =@CD_PROD_ORIG 
	   
    print 'EST_PROD_PRECIFICACAO_PRECO '
    SET @ErrorTable = 'EST_PROD_PRECIFICACAO_PRECO'
    DELETE FROM  EST_PROD_PRECIFICACAO_PRECO WHERE CD_PROD =@CD_PROD_ORIG 
	   
	print 'EST_PROD_ENT_GRP_ECON '
    SET @ErrorTable = 'EST_PROD_ENT_GRP_ECON'
    DELETE FROM  EST_PROD_ENT_GRP_ECON WHERE CD_PROD =@CD_PROD_ORIG 
	 
	print 'EST_NF_ENT_IT'    
    SET @ErrorTable = 'EST_NF_ENT_IT'
    UPDATE  EST_NF_ENT_IT SET CD_PROD =@CD_PROD_DEST   WHERE CD_EMP = 1 AND CD_PROD =@CD_PROD_ORIG 


declare @CD_PED int
SET @cd_filial =NULL
declare PEDIDOS cursor for
SELECT 
	   a.cd_filial
	  ,a.cd_ped 
FROM 
    EST_PED_VD_IT A 
    JOIN EST_PED_VD_IT B ON 
    A.CD_EMP	 = B.CD_EMP AND
    A.cd_ped	 = B.cd_ped AND
    A.CD_FILIAL = B.CD_FILIAL
WHERE
		A.CD_EMP = @CD_EMP
	AND A.CD_PROD =@CD_PROD_ORIG
    AND B.CD_PROD =@CD_PROD_DEST
OPEN PEDIDOS

  --Atribuindo valores do select nas variveis
  FETCH NEXT FROM PEDIDOS INTO @CD_FILIAL,@CD_PED


  --Iniciando lao
  WHILE @@FETCH_STATUS = 0
   BEGIN 

      UPDATE EST_PED_VD_IT
  SET
      QT_IT =
(
    SELECT SUM(QT_IT)
    FROM EST_PED_VD_IT
    WHERE cd_emp = @CD_EMP
		and cd_ped = @CD_PED
          AND cd_filial = @CD_FILIAL
          AND cd_prod IN(@CD_PROD_ORIG, @CD_PROD_DEST)
)
    WHERE cd_emp = @CD_EMP
		and cd_ped = @CD_PED
          AND cd_filial = @CD_FILIAL
          AND cd_prod IN(@CD_PROD_ORIG, @CD_PROD_DEST);

    DELETE FROM EST_PED_VD_IT
    WHERE cd_emp = @CD_EMP
		AND cd_ped = @CD_PED
		AND cd_filial = @CD_FILIAL
		AND cd_prod = @CD_PROD_ORIG;
   FETCH NEXT FROM PEDIDOS INTO @CD_FILIAL,@CD_PED
   end 
CLOSE PEDIDOS
DEALLOCATE PEDIDOS 


 IF  EXISTS (SELECT A.CD_EMP 
			   FROM EST_PED_VD_IT A 
			  WHERE A.CD_PROD	= @CD_PROD_ORIG		 
			)
		
	ALTER TABLE EST_PED_VD_IT_EST_PROD_CPL_LOTE NOCHECK CONSTRAINT FK_EST_PED_VD_IT_EST_PROD_CPL_LOTE_EST_PED_VD_IT
	
	print 'EST_PED_VD_IT'    
	SET @ErrorTable = 'EST_PED_VD_IT' 
	UPDATE  EST_PED_VD_IT SET CD_PROD =@CD_PROD_DEST   WHERE CD_EMP = 1 AND CD_PROD =@CD_PROD_ORIG 
	
	ALTER TABLE EST_PED_VD_IT_EST_PROD_CPL_LOTE CHECK CONSTRAINT FK_EST_PED_VD_IT_EST_PROD_CPL_LOTE_EST_PED_VD_IT


    
     
    	print 'EST_NF_ENT_DANFE_PROVISORIO_ITENS'    
    SET @ErrorTable = 'EST_NF_ENT_DANFE_PROVISORIO_ITENS' 
    UPDATE  EST_NF_ENT_DANFE_PROVISORIO_ITENS SET CD_PROD =@CD_PROD_DEST   WHERE CD_EMP = 1 AND CD_PROD =@CD_PROD_ORIG 
--------------------------------------------------------------------------------------------------------------------------------------------
-- 
--------------------------------------------------------------------------------------------------------------------------------------------

    print 'PDV_CAMPANHA_OPERADOR_EST_PROD_CPL '
    SET @ErrorTable = 'PDV_CAMPANHA_OPERADOR_EST_PROD_CPL'
    DELETE FROM  PDV_CAMPANHA_OPERADOR_EST_PROD_CPL WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'PDV_CAMPANHA_ADICIONAIS_EST_PROD '
    SET @ErrorTable = 'PDV_CAMPANHA_ADICIONAIS_EST_PROD'
    DELETE FROM  PDV_CAMPANHA_ADICIONAIS_EST_PROD WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'GLB_OPER_CEL '
    SET @ErrorTable = 'GLB_OPER_CEL'
    DELETE FROM  GLB_OPER_CEL WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_VINC '
    SET @ErrorTable = 'EST_PROD_VINC'
    DELETE FROM  EST_PROD_VINC WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_TRANSF_IT '
    SET @ErrorTable = 'EST_PROD_TRANSF_IT'
    DELETE FROM  EST_PROD_TRANSF_IT WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_TRANSF_FALTAS '
    SET @ErrorTable = 'EST_PROD_TRANSF_FALTAS'
    DELETE FROM  EST_PROD_TRANSF_FALTAS WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_TRANSF_CONF_FASES_ITENS '
    SET @ErrorTable = 'EST_PROD_TRANSF_CONF_FASES_ITENS'
    DELETE FROM  EST_PROD_TRANSF_CONF_FASES_ITENS WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_TABLOIDE_CPL '
    SET @ErrorTable = 'EST_PROD_TABLOIDE_CPL'
    DELETE FROM  EST_PROD_TABLOIDE_CPL WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_SAZONALIDADE '
    SET @ErrorTable = 'EST_PROD_SAZONALIDADE'
    DELETE FROM  EST_PROD_SAZONALIDADE WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_REQ_TRANSF_SLD '
    SET @ErrorTable = 'EST_PROD_REQ_TRANSF_SLD'
    DELETE FROM  EST_PROD_REQ_TRANSF_SLD WHERE CD_PROD =@CD_PROD_ORIG 

    print 'EST_PROD_REQ_TRANSF_RESERV '
    SET @ErrorTable = 'EST_PROD_REQ_TRANSF_RESERV'
    DELETE FROM  EST_PROD_REQ_TRANSF_RESERV WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP '
    SET @ErrorTable = 'EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP'
    DELETE FROM  EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP WHERE CD_PROD =@CD_PROD_ORIG
     
    print 'EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP '
    SET @ErrorTable = 'EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP'
    DELETE FROM  EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_REQ_TRANSF_LIB_ITENS '
    SET @ErrorTable = 'EST_PROD_REQ_TRANSF_LIB_ITENS'
    DELETE FROM  EST_PROD_REQ_TRANSF_LIB_ITENS WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_REQ_FORN_CPL_EST_PROD_IMP '
    SET @ErrorTable = 'EST_PROD_REQ_FORN_CPL_EST_PROD_IMP'
    DELETE FROM  EST_PROD_REQ_FORN_CPL_EST_PROD_IMP WHERE CD_PROD =@CD_PROD_ORIG
     
    print 'EST_PROD_REQ_FORN_CPL '
    SET @ErrorTable = 'EST_PROD_REQ_FORN_CPL'
    DELETE FROM  EST_PROD_REQ_FORN_CPL WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_REQ_ETQ_CPL '
    SET @ErrorTable = 'EST_PROD_REQ_ETQ_CPL'
    DELETE FROM  EST_PROD_REQ_ETQ_CPL WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_REQ_CPL_EST_PROD_IMP '
    SET @ErrorTable = 'EST_PROD_REQ_CPL_EST_PROD_IMP'
    DELETE FROM  EST_PROD_REQ_CPL_EST_PROD_IMP WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_REQ_CPL '
    SET @ErrorTable = 'EST_PROD_REQ_CPL'
    DELETE FROM  EST_PROD_REQ_CPL WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_REQ_CLI_CPL_EST_PED_VD_IT '
    SET @ErrorTable = 'EST_PROD_REQ_CLI_CPL_EST_PED_VD_IT'
    DELETE FROM  EST_PROD_REQ_CLI_CPL_EST_PED_VD_IT WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_REQ_CLI_CPL_CANCEL_SLD '
    SET @ErrorTable = 'EST_PROD_REQ_CLI_CPL_CANCEL_SLD'
    DELETE FROM  EST_PROD_REQ_CLI_CPL_CANCEL_SLD WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_REQ_CLI_CPL '
    SET @ErrorTable = 'EST_PROD_REQ_CLI_CPL'
    DELETE FROM  EST_PROD_REQ_CLI_CPL WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_REFERENCIA '
    SET @ErrorTable = 'EST_PROD_REFERENCIA'
    DELETE FROM  EST_PROD_REFERENCIA WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_REF '
    SET @ErrorTable = 'EST_PROD_REF'
    DELETE FROM  EST_PROD_REF WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_RC_CLI_ULT_CP '
    SET @ErrorTable = 'EST_PROD_RC_CLI_ULT_CP'
    DELETE FROM  EST_PROD_RC_CLI_ULT_CP WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_RC_CLI_CONV '
    SET @ErrorTable = 'EST_PROD_RC_CLI_CONV'
    DELETE FROM  EST_PROD_RC_CLI_CONV WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_PRINC_ATIVOS_EST_PROD '
    SET @ErrorTable = 'EST_PROD_PRINC_ATIVOS_EST_PROD'
    DELETE FROM  EST_PROD_PRINC_ATIVOS_EST_PROD WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_PRECO_TBL_HIST_CPL '
    SET @ErrorTable = 'EST_PROD_PRECO_TBL_HIST_CPL'
    DELETE FROM  EST_PROD_PRECO_TBL_HIST_CPL WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_PRECO_TBL '
    SET @ErrorTable = 'EST_PROD_PRECO_TBL'
    DELETE FROM  EST_PROD_PRECO_TBL WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_PRECO_GRP_FIDEL_EST_PROD '
    SET @ErrorTable = 'EST_PROD_PRECO_GRP_FIDEL_EST_PROD'
    DELETE FROM  EST_PROD_PRECO_GRP_FIDEL_EST_PROD WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_PRECO_DESC_PRG_CPL '
    SET @ErrorTable = 'EST_PROD_PRECO_DESC_PRG_CPL'
    DELETE FROM  EST_PROD_PRECO_DESC_PRG_CPL WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_PRECO_DESC_CLAS_CLIENTE_CPL '
    SET @ErrorTable = 'EST_PROD_PRECO_DESC_CLAS_CLIENTE_CPL'
    DELETE FROM  EST_PROD_PRECO_DESC_CLAS_CLIENTE_CPL WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_PRECO_DESC_ANIVER_CPL '
    SET @ErrorTable = 'EST_PROD_PRECO_DESC_ANIVER_CPL'
    DELETE FROM  EST_PROD_PRECO_DESC_ANIVER_CPL WHERE CD_PROD =@CD_PROD_ORIG
     
	 print 'EST_PROD_PRECO_ALT_CPL_LIB'
    SET @ErrorTable = 'EST_PROD_PRECO_ALT_CPL_LIB'
    DELETE FROM  EST_PROD_PRECO_ALT_CPL_LIB WHERE CD_PROD =@CD_PROD_ORIG 
	
    print 'EST_PROD_PRECO_ALT_CPL '
    SET @ErrorTable = 'EST_PROD_PRECO_ALT_CPL'
    DELETE FROM  EST_PROD_PRECO_ALT_CPL WHERE CD_PROD =@CD_PROD_ORIG 
	
    print 'EST_PROD_PRECO '
    SET @ErrorTable = 'EST_PROD_PRECO'
    DELETE FROM  EST_PROD_PRECO WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_PRECIFICACAO_VERBAS_IT '
    SET @ErrorTable = 'EST_PROD_PRECIFICACAO_VERBAS_IT'
    DELETE FROM  EST_PROD_PRECIFICACAO_VERBAS_IT WHERE CD_PROD =@CD_PROD_ORIG
    
    print 'EST_PROD_PRECIFICACAO_PRECO_AUDIT ' 
    SET @ErrorTable = 'EST_PROD_PRECIFICACAO_PRECO_AUDIT'
    DELETE FROM  EST_PROD_PRECIFICACAO_PRECO_AUDIT WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO '
    SET @ErrorTable = 'EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO'
    DELETE FROM  EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_PRECIFICACAO_HISTORICO '
    SET @ErrorTable = 'EST_PROD_PRECIFICACAO_HISTORICO'
    DELETE FROM  EST_PROD_PRECIFICACAO_HISTORICO WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_PRECIFICACAO_BLOQUEIOS '
    SET @ErrorTable = 'EST_PROD_PRECIFICACAO_BLOQUEIOS'
    DELETE FROM  EST_PROD_PRECIFICACAO_BLOQUEIOS WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_PERC_ICMS_INTER '
    SET @ErrorTable = 'EST_PROD_PERC_ICMS_INTER'
    DELETE FROM  EST_PROD_PERC_ICMS_INTER WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_PAD '
    SET @ErrorTable = 'EST_PROD_PAD'
    DELETE FROM  EST_PROD_PAD WHERE CD_PROD =@CD_PROD_ORIG 
	
    print 'EST_ARV_MERC_MIX_ANALISE_VENDAS '
    SET @ErrorTable = 'EST_ARV_MERC_MIX_ANALISE_VENDAS'
    DELETE FROM  EST_ARV_MERC_MIX_ANALISE_VENDAS WHERE CD_PROD =@CD_PROD_ORIG
	
    print 'EST_PROD_MIX_STATUS '
    SET @ErrorTable = 'EST_PROD_MIX_STATUS'
    DELETE FROM  EST_PROD_MIX_STATUS WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_KIT_CPL '
    SET @ErrorTable = 'EST_PROD_KIT_CPL'
    DELETE FROM  EST_PROD_KIT_CPL WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_INVENTARIO '
    SET @ErrorTable = 'EST_PROD_INVENTARIO'
    DELETE FROM  EST_PROD_INVENTARIO WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_INF_DIVERS '
    SET @ErrorTable = 'EST_PROD_INF_DIVERS'
    DELETE FROM  EST_PROD_INF_DIVERS WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_IMP_FLUTUANTE '
    SET @ErrorTable = 'EST_PROD_IMP_FLUTUANTE'
    DELETE FROM  EST_PROD_IMP_FLUTUANTE WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_IMP_EST_PROD_REQ_CLI '
    SET @ErrorTable = 'EST_PROD_IMP_EST_PROD_REQ_CLI'
    DELETE FROM  EST_PROD_IMP_EST_PROD_REQ_CLI WHERE CD_PROD =@CD_PROD_ORIG
     
    print 'EST_PROD_IMP_EST_PROD_CPL_LOTE '
    SET @ErrorTable = 'EST_PROD_IMP_EST_PROD_CPL_LOTE'
    DELETE FROM  EST_PROD_IMP_EST_PROD_CPL_LOTE WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_IMP_EST_PROD_BALAN_IT_DIVERG '
    SET @ErrorTable = 'EST_PROD_IMP_EST_PROD_BALAN_IT_DIVERG'
    DELETE FROM  EST_PROD_IMP_EST_PROD_BALAN_IT_DIVERG WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_IMP_EST_PROD_BALAN_IT '
    SET @ErrorTable = 'EST_PROD_IMP_EST_PROD_BALAN_IT'
    DELETE FROM  EST_PROD_IMP_EST_PROD_BALAN_IT WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT '
    SET @ErrorTable = 'PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT'
    DELETE FROM  PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'PDV_VD_DEV_EST_PROD_IMP_PEND_NF '
    SET @ErrorTable = 'PDV_VD_DEV_EST_PROD_IMP_PEND_NF'
    DELETE FROM  PDV_VD_DEV_EST_PROD_IMP_PEND_NF WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP '
    SET @ErrorTable = 'PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP'
    DELETE FROM  PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'PDV_VD_DEV_EST_PROD_IMP '
    SET @ErrorTable = 'PDV_VD_DEV_EST_PROD_IMP'
    DELETE FROM  PDV_VD_DEV_EST_PROD_IMP WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_IMP_DETERIORADO '
    SET @ErrorTable = 'EST_PROD_IMP_DETERIORADO'
    DELETE FROM  EST_PROD_IMP_DETERIORADO WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_IMP_LIBERACAO_ALCADA '
    SET @ErrorTable = 'EST_PROD_IMP_LIBERACAO_ALCADA'
    DELETE FROM  EST_PROD_IMP_LIBERACAO_ALCADA WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_CRONO_CONTAGEM_EFET_EST_PROD_IMP '
    SET @ErrorTable = 'EST_PROD_CRONO_CONTAGEM_EFET_EST_PROD_IMP'
    DELETE FROM  EST_PROD_CRONO_CONTAGEM_EFET_EST_PROD_IMP WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
	
    print 'EST_PROD_IMP '
    SET @ErrorTable = 'EST_PROD_IMP'
    DELETE FROM  EST_PROD_IMP WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_GRP_CONTAGEM_CPL '
    SET @ErrorTable = 'EST_PROD_GRP_CONTAGEM_CPL'
    DELETE FROM  EST_PROD_GRP_CONTAGEM_CPL WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_GLB_MAQUINAS '
    SET @ErrorTable = 'EST_PROD_GLB_MAQUINAS'
    DELETE FROM  EST_PROD_GLB_MAQUINAS WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_FORN '
    SET @ErrorTable = 'EST_PROD_FORN'
    DELETE FROM  EST_PROD_FORN WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_FARMACIA_POPULAR '
    SET @ErrorTable = 'EST_PROD_FARMACIA_POPULAR'
    DELETE FROM  EST_PROD_FARMACIA_POPULAR WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_EST_PROD_TRANSF_SC_ESPECIAL '
    SET @ErrorTable = 'EST_PROD_EST_PROD_TRANSF_SC_ESPECIAL'
    DELETE FROM  EST_PROD_EST_PROD_TRANSF_SC_ESPECIAL WHERE CD_PROD =@CD_PROD_ORIG
     
    print 'EST_PROD_CPL_CUSTO_ZERADO_PENDENTE '
    SET @ErrorTable = 'EST_PROD_CPL_CUSTO_ZERADO_PENDENTE'
    DELETE FROM  EST_PROD_CPL_CUSTO_ZERADO_PENDENTE WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE '
    SET @ErrorTable = 'EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE'
    DELETE FROM  EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_EST_PROD_GEN_NCM '
    SET @ErrorTable = 'EST_PROD_EST_PROD_GEN_NCM'
    DELETE FROM  EST_PROD_EST_PROD_GEN_NCM WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_EST_PROD_CLASSE '
    SET @ErrorTable = 'EST_PROD_EST_PROD_CLASSE'
    DELETE FROM  EST_PROD_EST_PROD_CLASSE WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_ARV_MERC_MIX_ANALISE_ESTOQUE '
    SET @ErrorTable = 'EST_ARV_MERC_MIX_ANALISE_ESTOQUE'
    DELETE FROM  EST_ARV_MERC_MIX_ANALISE_ESTOQUE WHERE CD_PROD =@CD_PROD_ORIG
    
    print 'EST_PROD_EST_ARV_MERCADOLOGICA ' 
    SET @ErrorTable = 'EST_PROD_EST_ARV_MERCADOLOGICA'
    DELETE FROM  EST_PROD_EST_ARV_MERCADOLOGICA WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT '
    SET @ErrorTable = 'EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT'
    DELETE FROM  EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT WHERE CD_PROD =@CD_PROD_ORIG 
    
    print 'EST_FECHA '
    SET @ErrorTable = 'EST_FECHA'
    DELETE FROM  EST_FECHA WHERE CD_EMP = @CD_EMP and CD_PROD =@CD_PROD_ORIG
    
    

--------------------------------------------------------------------------------------------------------------------------------------------
--ALTERANDO PRODUTO NA MELHOR CONDIAO DE COMPRA
--------------------------------------------------------------------------------------------------------------------------------------------
    
    print 'EST_PROD_COND_CP_PG_FORN 'DECLARE @CD_FORN INT
    SET @ErrorTable = 'EST_PROD_COND_CP_PG_FORN'
    DECLARE COND_CP CURSOR FOR 
    SELECT  
		  CD_FORN
    FROM EST_PROD_COND_CP_PG_FORN
    WHERE	  CD_EMP =1  
		  AND CD_PROD = @CD_PROD_ORIG
    OPEN COND_CP 
    FETCH NEXT FROM COND_CP INTO @CD_FORN
    WHILE @@FETCH_STATUS = 0
    BEGIN 
	   
	   IF EXISTS(SELECT 1 from EST_PROD_COND_CP_PG_FORN
			   WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_DEST AND CD_FORN = @CD_FORN )
		  BEGIN
			 DELETE FROM  EST_PROD_COND_CP_PG_FORN 
			   WHERE CD_EMP = @CD_EMP 
				    AND CD_PROD = @CD_PROD_ORIG
				    AND CD_FORN = @CD_FORN 
				    
		  END 
		  ELSE 
	   UPDATE EST_PROD_COND_CP_PG_FORN 
		  SET CD_PROD =@CD_PROD_DEST 
	   WHERE CD_EMP = 1 
		    AND CD_PROD = @CD_PROD_ORIG
		    AND CD_FORN = @CD_FORN 

		
	   FETCH NEXT FROM COND_CP INTO @CD_FORN

    END
    CLOSE COND_CP
    DEALLOCATE COND_CP 
--------------------------------------------------------------------------------------------------------------------------------------------
-- 
--------------------------------------------------------------------------------------------------------------------------------------------
    
    print 'EST_PROD_DETE_IT '
    SET @ErrorTable = 'EST_PROD_DETE_IT'
    DELETE FROM  EST_PROD_DETE_IT WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CURVA_HIST_IT '
    SET @ErrorTable = 'EST_PROD_CURVA_HIST_IT'
    DELETE FROM  EST_PROD_CURVA_HIST_IT WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CRONO_CONTAGEM_EFET '
    SET @ErrorTable = 'EST_PROD_CRONO_CONTAGEM_EFET'
    DELETE FROM  EST_PROD_CRONO_CONTAGEM_EFET WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CRONO_CONTAGEM_EFET_PROC '
    SET @ErrorTable = 'EST_PROD_CRONO_CONTAGEM_EFET_PROC'
    DELETE FROM  EST_PROD_CRONO_CONTAGEM_EFET_PROC WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PED_VD_IT_EST_PROD_CPL_LOTE '
    SET @ErrorTable = 'EST_PED_VD_IT_EST_PROD_CPL_LOTE'
    UPDATE  EST_PED_VD_IT_EST_PROD_CPL_LOTE SET CD_PROD = @CD_PROD_DEST WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PED_VD_IT_CONF_VALID '
    SET @ErrorTable = 'EST_PED_VD_IT_CONF_VALID'
    UPDATE  EST_PED_VD_IT_CONF_VALID SET CD_PROD = @CD_PROD_DEST WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PED_VD_IT_CONF '
    SET @ErrorTable = 'EST_PED_VD_IT_CONF'
    UPDATE  EST_PED_VD_IT_CONF SET CD_PROD = @CD_PROD_DEST WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
     
    print 'EST_PED_ELTR_SUPRIMENTO_IT_MESES '  
    SET @ErrorTable = 'EST_PED_ELTR_SUPRIMENTO_IT_MESES'
    DELETE FROM  EST_PED_ELTR_SUPRIMENTO_IT_MESES WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PED_ELTR_SUPRIMENTO_IT '
    SET @ErrorTable = 'EST_PED_ELTR_SUPRIMENTO_IT'
    DELETE FROM  EST_PED_ELTR_SUPRIMENTO_IT WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PED_ELTR_SUPRIMENTO_AUDITORIA_PEDIDO '
    SET @ErrorTable = 'EST_PED_ELTR_SUPRIMENTO_AUDITORIA_PEDIDO'
    DELETE FROM  EST_PED_ELTR_SUPRIMENTO_AUDITORIA_PEDIDO WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PED_ELTR_FORN_IT '
    SET @ErrorTable = 'EST_PED_ELTR_FORN_IT'
    DELETE FROM  EST_PED_ELTR_FORN_IT WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PED_ELTR_FORN_FALTAS '
    SET @ErrorTable = 'EST_PED_ELTR_FORN_FALTAS'
    DELETE FROM  EST_PED_ELTR_FORN_FALTAS WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PED_ELTR_IT '
    SET @ErrorTable = 'EST_PED_ELTR_IT'
    DELETE FROM  EST_PED_ELTR_IT WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PED_ELTR_DEMANDA '
    SET @ErrorTable = 'EST_PED_ELTR_DEMANDA'
    DELETE FROM  EST_PED_ELTR_DEMANDA WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PED_CP_IT_CANCEL_SLD '
    SET @ErrorTable = 'EST_PED_CP_IT_CANCEL_SLD'
    DELETE FROM  EST_PED_CP_IT_CANCEL_SLD WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
 
    print 'EST_PED_CP_CONSUMO_IT '
    SET @ErrorTable = 'EST_PED_CP_CONSUMO_IT'
    UPDATE  EST_PED_CP_CONSUMO_IT SET CD_PROD = @CD_PROD_DEST WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_ORC_GLB_MEDICO '
    SET @ErrorTable = 'EST_ORC_GLB_MEDICO'
    DELETE FROM  EST_ORC_GLB_MEDICO WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_ORC_CPL_CONCOR '
    SET @ErrorTable = 'EST_ORC_CPL_CONCOR'
    DELETE FROM  EST_ORC_CPL_CONCOR WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_ORC_CPL '
    SET @ErrorTable = 'EST_ORC_CPL'
    DELETE FROM  EST_ORC_CPL WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_OPERADORA_CELULAR_EST_PROD '
    SET @ErrorTable = 'EST_OPERADORA_CELULAR_EST_PROD'
    DELETE FROM  EST_OPERADORA_CELULAR_EST_PROD WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_NF_SAI_IT_EST_PROD_CPL_LOTE '
    SET @ErrorTable = 'EST_NF_SAI_IT_EST_PROD_CPL_LOTE'
    UPDATE  EST_NF_SAI_IT_EST_PROD_CPL_LOTE SET CD_PROD = @CD_PROD_DEST WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG  
     
    print 'EST_NF_ENT_PRE_ENTRADA_CPL_CONF ' 
    SET @ErrorTable = 'EST_NF_ENT_PRE_ENTRADA_CPL_CONF'
    UPDATE  EST_NF_ENT_PRE_ENTRADA_CPL_CONF SET CD_PROD = @CD_PROD_DEST WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_NF_ENT_PRE_ENTRADA_CPL '
    SET @ErrorTable = 'EST_NF_ENT_PRE_ENTRADA_CPL'
    UPDATE  EST_NF_ENT_PRE_ENTRADA_CPL SET CD_PROD = @CD_PROD_DEST WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_NF_ENT_IT_EST_PROD_CPL_LOTE '
    SET @ErrorTable = 'EST_NF_ENT_IT_EST_PROD_CPL_LOTE'
    UPDATE  EST_NF_ENT_IT_EST_PROD_CPL_LOTE SET CD_PROD = @CD_PROD_DEST WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_BLOQUEIO_AUDIT '
    SET @ErrorTable = 'EST_PROD_CPL_BLOQUEIO_AUDIT'
    UPDATE  EST_PROD_CPL_BLOQUEIO_AUDIT SET CD_PROD = @CD_PROD_DEST WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_NF_ENT_DAR_IT '
    SET @ErrorTable = 'EST_NF_ENT_DAR_IT'
    DELETE FROM  EST_NF_ENT_DAR_IT WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_CARGA_VENDAS_SEMESTRAL '
    SET @ErrorTable = 'EST_CARGA_VENDAS_SEMESTRAL'
    DELETE FROM  EST_CARGA_VENDAS_SEMESTRAL WHERE CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_UN_EST '
    SET @ErrorTable = 'EST_PROD_CPL_UN_EST'
    DELETE FROM  EST_PROD_CPL_UN_EST WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_ULT_MOV_PDV_VD '
    SET @ErrorTable = 'EST_PROD_CPL_ULT_MOV_PDV_VD'
    DELETE FROM  EST_PROD_CPL_ULT_MOV_PDV_VD WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_ULT_MOV_GLB_MOV_OP '
    SET @ErrorTable = 'EST_PROD_CPL_ULT_MOV_GLB_MOV_OP'
    DELETE FROM  EST_PROD_CPL_ULT_MOV_GLB_MOV_OP WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_SEM_ESTOQUE '
    SET @ErrorTable = 'EST_PROD_CPL_SEM_ESTOQUE'
    DELETE FROM  EST_PROD_CPL_SEM_ESTOQUE WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_RESERV '
    SET @ErrorTable = 'EST_PROD_CPL_RESERV'
    DELETE FROM  EST_PROD_CPL_RESERV WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_PROC '
    SET @ErrorTable = 'EST_PROD_CPL_PROC'
    DELETE FROM  EST_PROD_CPL_PROC WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_PARM_END '
    SET @ErrorTable = 'EST_PROD_CPL_PARM_END'
    DELETE FROM  EST_PROD_CPL_PARM_END WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_NASC '
    SET @ErrorTable = 'EST_PROD_CPL_NASC'
    DELETE FROM  EST_PROD_CPL_NASC WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_MEDIAP '
    SET @ErrorTable = 'EST_PROD_CPL_MEDIAP'
    DELETE FROM  EST_PROD_CPL_MEDIAP WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_MEDIAF_AUDIT '
    SET @ErrorTable = 'EST_PROD_CPL_MEDIAF_AUDIT'
    DELETE FROM  EST_PROD_CPL_MEDIAF_AUDIT WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_MEDIAF '
    SET @ErrorTable = 'EST_PROD_CPL_MEDIAF'
    DELETE FROM  EST_PROD_CPL_MEDIAF WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_LOTE '
    SET @ErrorTable = 'EST_PROD_CPL_LOTE'
    UPDATE EST_PROD_CPL_LOTE SET CD_PROD =@CD_PROD_DEST WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    --DELETE FROM  EST_PROD_CPL_LOTE WHERE CD_EMP = 1 AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_IMP_ETQ '
    SET @ErrorTable = 'EST_PROD_CPL_IMP_ETQ'
    DELETE FROM  EST_PROD_CPL_IMP_ETQ WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_FALTA_CRONICA '
    SET @ErrorTable = 'EST_PROD_CPL_FALTA_CRONICA'
    DELETE FROM  EST_PROD_CPL_FALTA_CRONICA WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_EST_PED_CP_CONSUMO_IT '
    SET @ErrorTable = 'EST_PROD_CPL_EST_PED_CP_CONSUMO_IT'
    DELETE FROM  EST_PROD_CPL_EST_PED_CP_CONSUMO_IT WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_EST_NF_IT_ULTIMA '
    SET @ErrorTable = 'EST_PROD_CPL_EST_NF_IT_ULTIMA'
    DELETE FROM  EST_PROD_CPL_EST_NF_IT_ULTIMA WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_BALAN_IT_ALT '
    SET @ErrorTable = 'EST_PROD_BALAN_IT_ALT'
    DELETE FROM  EST_PROD_BALAN_IT_ALT WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_BALAN_IT '
    SET @ErrorTable = 'EST_PROD_BALAN_IT'
    DELETE FROM  EST_PROD_BALAN_IT WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_COT_FORN_CPL '
    SET @ErrorTable = 'EST_PROD_COT_FORN_CPL'
    DELETE FROM  EST_PROD_COT_FORN_CPL WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_COMP '
    SET @ErrorTable = 'EST_PROD_COMP'
    DELETE FROM  EST_PROD_COMP WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CD_BARRA_PDV '
    SET @ErrorTable = 'EST_PROD_CD_BARRA_PDV'
    DELETE FROM  EST_PROD_CD_BARRA_PDV WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CD_BARRA '
    SET @ErrorTable = 'EST_PROD_CD_BARRA'
    DELETE FROM  EST_PROD_CD_BARRA WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_ACERTO_CUSTO '
    SET @ErrorTable = 'EST_PROD_CPL_ACERTO_CUSTO'
    DELETE FROM  EST_PROD_CPL_ACERTO_CUSTO WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_CPL_VD '
    SET @ErrorTable = 'EST_PROD_CPL_VD'
    DELETE FROM  EST_PROD_CPL_VD WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
	print 'EST_PROD_CPL_FACE_PERMANENTE '
    SET @ErrorTable = 'EST_PROD_CPL_FACE_PERMANENTE'
    DELETE FROM  EST_PROD_CPL_FACE_PERMANENTE WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
	
	print 'EST_PED_CP_IT '
    SET @ErrorTable = 'EST_PED_CP_IT'
    DELETE FROM  EST_PED_CP_IT WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
	

    print 'EST_PROD_PRECO_OFERTA_PERMANENTE '
    SET @ErrorTable = 'EST_PROD_PRECO_OFERTA_PERMANENTE'
	IF EXISTS (SELECT A.CD_PROD  
				 FROM EST_PROD_PRECO_OFERTA_PERMANENTE A 
					  JOIN EST_PROD_CPL B ON A.CD_FILIAL = B.CD_FILIAL
										 AND A.CD_PROD   = B.CD_PROD
                WHERE A.CD_PROD  = @CD_PROD_ORIG ) 
	BEGIN 
		DELETE FROM EST_PROD_PRECO_OFERTA_PERMANENTE WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
	END;
	
	print 'EST_PROD_CPL '
    SET @ErrorTable = 'EST_PROD_CPL'
    DELETE FROM  EST_PROD_CPL WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_PRC_REGIAO_FISCAL_TRIB_INTER_DAR '
    SET @ErrorTable = 'EST_PROD_PRC_REGIAO_FISCAL_TRIB_INTER_DAR'
    DELETE FROM  EST_PROD_PRC_REGIAO_FISCAL_TRIB_INTER_DAR WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_PRC_REGIAO_FISCAL_TRIB_INTER '
    SET @ErrorTable = 'EST_PROD_PRC_REGIAO_FISCAL_TRIB_INTER'
    DELETE FROM  EST_PROD_PRC_REGIAO_FISCAL_TRIB_INTER WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_PRC_REGIAO_FISCAL_TRIB_EST '
    SET @ErrorTable = 'EST_PROD_PRC_REGIAO_FISCAL_TRIB_EST'
    DELETE FROM  EST_PROD_PRC_REGIAO_FISCAL_TRIB_EST WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_NF_SAI_CHECKIN_ENTRADA_CPL '
    SET @ErrorTable = 'EST_NF_SAI_CHECKIN_ENTRADA_CPL'
    DELETE FROM  EST_NF_SAI_CHECKIN_ENTRADA_CPL WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_WMS_ENT_IT '
    SET @ErrorTable = 'EST_WMS_ENT_IT'
    DELETE FROM  EST_WMS_ENT_IT WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_PRC_REGIAO_FISCAL_TRIB_EST_PEND '
    SET @ErrorTable = 'EST_PROD_PRC_REGIAO_FISCAL_TRIB_EST_PEND'
    DELETE FROM  EST_PROD_PRC_REGIAO_FISCAL_TRIB_EST_PEND WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PARAM_COMPRAS_PERFIL_EST_PROD '
    SET @ErrorTable = 'EST_PARAM_COMPRAS_PERFIL_EST_PROD'
    DELETE FROM  EST_PARAM_COMPRAS_PERFIL_EST_PROD WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_ORC_CPL_FALTA '
    SET @ErrorTable = 'EST_ORC_CPL_FALTA'
    UPDATE  EST_ORC_CPL_FALTA SET CD_PROD = @CD_PROD_DEST WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_GRP_COMIS_EST_PROD '
    SET @ErrorTable = 'EST_GRP_COMIS_EST_PROD'
    DELETE FROM  EST_GRP_COMIS_EST_PROD WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_TBL_DESC_EST_PROD '
    SET @ErrorTable = 'EST_PROD_TBL_DESC_EST_PROD'
    DELETE FROM  EST_PROD_TBL_DESC_EST_PROD WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO_EST_PROD '
    SET @ErrorTable = 'EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO_EST_PROD'
    DELETE FROM  EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO_EST_PROD WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    
    print 'EST_PROD_TBL_FIDEL_EST_PROD '
    SET @ErrorTable = 'EST_PROD_TBL_FIDEL_EST_PROD'
    DELETE FROM EST_PROD_TBL_FIDEL_EST_PROD WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
	
	print 'RC_CLI_CONV_BLOQ_LIBERA_PROD_EST_PROD '
    SET @ErrorTable = 'RC_CLI_CONV_BLOQ_LIBERA_PROD_EST_PROD'
    DELETE FROM RC_CLI_CONV_BLOQ_LIBERA_PROD_EST_PROD WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    

    IF NOT EXISTS (SELECT *  
                     FROM EST_PROD_EST_SNGPC 
    				WHERE CD_EMP  = @CD_EMP
					  AND CD_PROD = @CD_PROD_DEST
    				)
    BEGIN 
        PRINT 'EST_PROD_EST_SNGPC '
        SET @ERRORTABLE = 'EST_PROD_EST_SNGPC'
        UPDATE  EST_PROD_EST_SNGPC SET CD_PROD = @CD_PROD_DEST WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    END; 
	  

	print 'EST_PED_ELTR_COT_COMPRA_RET '
    SET @ErrorTable = 'EST_PED_ELTR_COT_COMPRA_RET'     
    DELETE EST_PED_ELTR_COT_COMPRA_RET WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    print 'EST_PROD_DESC_FINAN '
    SET @ErrorTable = 'EST_PROD_DESC_FINAN'       
    DELETE EST_PROD_DESC_FINAN WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG

    print 'EST_PROD '
    SET @ErrorTable = 'EST_PROD'       
    DELETE EST_PROD WHERE CD_EMP = @CD_EMP AND CD_PROD = @CD_PROD_ORIG
    

  END TRY
BEGIN CATCH 
	select 
	   @ErrorMessage = ERROR_MESSAGE (),
	   @ErrorSeverity=ERROR_SEVERITY (),
	   @ErrorState=ERROR_STATE (); 
	set @ErrorMessage = ISNULL(@ErrorTable,'')+ ' ' + @ErrorMessage   ;
	RAISERROR (@ErrorMessage,@ErrorSeverity,@ErrorState);

END CATCH
 
END

